#include "Timeframe.h"
#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "RelOrAbsTime.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

Timeframe::Timeframe() :
   minRunningTime(DEFAULT_VALUE_XS_INT),
   maxRunningTime(DEFAULT_VALUE_XS_INT)
{
}


void Timeframe::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("deviceId")) {
         sstream << indentXML(level_) << "<DeviceId>";
         sstream << deviceId;
         sstream << "</DeviceId>\n";
   }
   if (isSet("earliestStart")) {
         sstream << indentXML(level_) << "<EarliestStart>";
         sstream << earliestStart;
         sstream << "</EarliestStart>\n";
   }
   if (isSet("latestEnd")) {
         sstream << indentXML(level_) << "<LatestEnd>";
         sstream << latestEnd;
         sstream << "</LatestEnd>\n";
   }
   if (isSet("minRunningTime")) {
         sstream << indentXML(level_) << "<MinRunningTime>";
         sstream << minRunningTime;
         sstream << "</MinRunningTime>\n";
   }
   if (isSet("maxRunningTime")) {
         sstream << indentXML(level_) << "<MaxRunningTime>";
         sstream << maxRunningTime;
         sstream << "</MaxRunningTime>\n";
   }
}

bool Timeframe::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("deviceId")) { errElement_ = "deviceId"; return false; }
   if (!isSet("earliestStart")) { errElement_ = "earliestStart"; return false; }
   if (!isSet("latestEnd")) { errElement_ = "latestEnd"; return false; }
   if (!isSet("minRunningTime")) { errElement_ = "minRunningTime"; return false; }
   if (!isSet("maxRunningTime")) { errElement_ = "maxRunningTime"; return false; }
   return true;
}

}
