#ifndef POWERINFO_H_
#define POWERINFO_H_

#include "../SEMPCommon.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

/*! \class PowerInfo
 * Information about a power consumption.
 */
class PowerInfo : public SEMPObject
{
public:
   PowerInfo();
private:
   /*!
    * Real average power within the interval in Watts.
    */
   xs_int averagePower;

   /*!
    * Minimum power value within the interval in Watts.
    */
   xs_int minPower; /* occurs: 0 .. 1 */

   /*!
    * Maximum power within the interval in Watts.
    */
   xs_int maxPower; /* occurs: 0 .. 1 */

   /*!
    * Timestamp that represents the end of the averaging interval.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   RelOrAbsTime timestamp;

   /*!
    * Length of the averaging interval in seconds.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   xs_int averagingInterval;


public:
   /*!
    * @brief Setter for xs_int
    * Real average power within the interval in Watts.
    */
   void setAveragePower(xs_int value_) {
      averagePower = value_;
      markAsSet("averagePower");
   }

   /*!
    * @brief Getter for xs_int
    * Real average power within the interval in Watts.
    */
   xs_int getAveragePower() const {
      return averagePower;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isAveragePowerSet() const {
      return isSet("averagePower");
   }

   /*!
    * @brief Setter for xs_int
    * Minimum power value within the interval in Watts.
    */
   void setMinPower(xs_int value_) {
      minPower = value_;
      markAsSet("minPower");
   }

   /*!
    * @brief Getter for xs_int
    * Minimum power value within the interval in Watts.
    */
   xs_int getMinPower() const {
      return minPower;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMinPowerSet() const {
      return isSet("minPower");
   }

   /*!
    * @brief Setter for xs_int
    * Maximum power within the interval in Watts.
    */
   void setMaxPower(xs_int value_) {
      maxPower = value_;
      markAsSet("maxPower");
   }

   /*!
    * @brief Getter for xs_int
    * Maximum power within the interval in Watts.
    */
   xs_int getMaxPower() const {
      return maxPower;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMaxPowerSet() const {
      return isSet("maxPower");
   }

   /*!
    * @brief Setter for RelOrAbsTime
    * Timestamp that represents the end of the averaging interval.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   void setTimestamp(RelOrAbsTime const &value_) {
      timestamp = value_;
      markAsSet("timestamp");
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Timestamp that represents the end of the averaging interval.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   RelOrAbsTime& getTimestamp() {
      return timestamp;
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Timestamp that represents the end of the averaging interval.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   const RelOrAbsTime& getTimestamp() const {
      return timestamp;
   }

   /*!
    * @brief Checks if field RelOrAbsTime is set
    */
   bool isTimestampSet() const {
      return isSet("timestamp");
   }

   /*!
    * @brief Setter for xs_int
    * Length of the averaging interval in seconds.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   void setAveragingInterval(xs_int value_) {
      averagingInterval = value_;
      markAsSet("averagingInterval");
   }

   /*!
    * @brief Getter for xs_int
    * Length of the averaging interval in seconds.
            Although this element is marked as optional it is mandatory in PowerConsumption:PowerInfo.
    */
   xs_int getAveragingInterval() const {
      return averagingInterval;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isAveragingIntervalSet() const {
      return isSet("averagingInterval");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
