#include "PowerConsumption.h"
#include "../SEMPCommon.h"
#include "PowerInfo.h"

namespace SEMP
{

PowerConsumption::PowerConsumption()
{
}


void PowerConsumption::serializeXML(std::stringstream &sstream, int level_) const
{
   {
      for (size_t i = 0; i < powerInfo.size(); ++i) {
            sstream << indentXML(level_) << "<PowerInfo>\n";
            powerInfo[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</PowerInfo>\n";
      }
   }
}

bool PowerConsumption::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("powerInfo")) { errElement_ = "powerInfo"; return false; }
   for (size_t i = 0; i < powerInfo.size(); ++i)
      if (!powerInfo[i].validateXMLSchema(errElement_)) { errElement_ = "powerInfo/" + errElement_; return false; }
   return true;
}

}
