#include "MessageList.h"
#include "../SEMPCommon.h"
#include "Message.h"

namespace SEMP
{

MessageList::MessageList()
{
}


void MessageList::serializeXML(std::stringstream &sstream, int level_) const
{
   {
      for (size_t i = 0; i < message.size(); ++i) {
            sstream << indentXML(level_) << "<Message>\n";
            message[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</Message>\n";
      }
   }
}

bool MessageList::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("message")) { errElement_ = "message"; return false; }
   for (size_t i = 0; i < message.size(); ++i)
      if (!message[i].validateXMLSchema(errElement_)) { errElement_ = "message/" + errElement_; return false; }
   return true;
}

}
