#ifndef MESSAGEDATA_H_
#define MESSAGEDATA_H_

#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

/*! \class MessageData
 * Additional data describing the error/event.
 */
class MessageData : public SEMPObject
{
public:
   MessageData();
private:
   /*!
    * Unique identification of the device this message applies to.
    */
   DeviceId deviceId; /* occurs: 0 .. 1 */

   /*!
    * Time of the occurrence of the error/event.
    */
   RelOrAbsTime timestamp; /* occurs: 0 .. 1 */


public:
   /*!
    * @brief Setter for DeviceId
    * Unique identification of the device this message applies to.
    */
   void setDeviceId(DeviceId const &value_) {
      deviceId = value_;
      markAsSet("deviceId");
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device this message applies to.
    */
   DeviceId& getDeviceId() {
      return deviceId;
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device this message applies to.
    */
   const DeviceId& getDeviceId() const {
      return deviceId;
   }

   /*!
    * @brief Checks if field DeviceId is set
    */
   bool isDeviceIdSet() const {
      return isSet("deviceId");
   }

   /*!
    * @brief Setter for RelOrAbsTime
    * Time of the occurrence of the error/event.
    */
   void setTimestamp(RelOrAbsTime const &value_) {
      timestamp = value_;
      markAsSet("timestamp");
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Time of the occurrence of the error/event.
    */
   RelOrAbsTime& getTimestamp() {
      return timestamp;
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Time of the occurrence of the error/event.
    */
   const RelOrAbsTime& getTimestamp() const {
      return timestamp;
   }

   /*!
    * @brief Checks if field RelOrAbsTime is set
    */
   bool isTimestampSet() const {
      return isSet("timestamp");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
