#ifndef IDENTIFICATION_H_
#define IDENTIFICATION_H_

#include "../SEMPCommon.h"
#include "DeviceId.h"

namespace SEMP
{

/*! \class Identification
 * General information for identifying the device.
 */
class Identification : public SEMPObject
{
public:
   Identification();
private:
   /*!
    * Unique identification of the device.
    */
   DeviceId deviceId;

   /*!
    * Human readable device name
    */
   xs_string deviceName;

   /*!
    * Human readable type of the device. See DeviceTypeRefType for well-known types.
    */
   xs_string deviceType;

   /*!
    * Vendor specific serial number of the device
    */
   xs_string deviceSerial;

   /*!
    * Human readable name of the device vendor
    */
   xs_string deviceVendor;

   /*!
    * Configuration URL of the device.
    */
   xs_string deviceURL; /* occurs: 0 .. 1 */


public:
   /*!
    * @brief Setter for DeviceId
    * Unique identification of the device.
    */
   void setDeviceId(DeviceId const &value_) {
      deviceId = value_;
      markAsSet("deviceId");
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   DeviceId& getDeviceId() {
      return deviceId;
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   const DeviceId& getDeviceId() const {
      return deviceId;
   }

   /*!
    * @brief Checks if field DeviceId is set
    */
   bool isDeviceIdSet() const {
      return isSet("deviceId");
   }

   /*!
    * @brief Setter for xs_string
    * Human readable device name
    */
   void setDeviceName(xs_string const &value_) {
      deviceName = value_;
      markAsSet("deviceName");
   }

   /*!
    * @brief Getter for xs_string
    * Human readable device name
    */
   xs_string& getDeviceName() {
      return deviceName;
   }

   /*!
    * @brief Getter for xs_string
    * Human readable device name
    */
   const xs_string& getDeviceName() const {
      return deviceName;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isDeviceNameSet() const {
      return isSet("deviceName");
   }

   /*!
    * @brief Setter for xs_string
    * Human readable type of the device. See DeviceTypeRefType for well-known types.
    */
   void setDeviceType(xs_string const &value_) {
      deviceType = value_;
      markAsSet("deviceType");
   }

   /*!
    * @brief Getter for xs_string
    * Human readable type of the device. See DeviceTypeRefType for well-known types.
    */
   xs_string& getDeviceType() {
      return deviceType;
   }

   /*!
    * @brief Getter for xs_string
    * Human readable type of the device. See DeviceTypeRefType for well-known types.
    */
   const xs_string& getDeviceType() const {
      return deviceType;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isDeviceTypeSet() const {
      return isSet("deviceType");
   }

   /*!
    * @brief Setter for xs_string
    * Vendor specific serial number of the device
    */
   void setDeviceSerial(xs_string const &value_) {
      deviceSerial = value_;
      markAsSet("deviceSerial");
   }

   /*!
    * @brief Getter for xs_string
    * Vendor specific serial number of the device
    */
   xs_string& getDeviceSerial() {
      return deviceSerial;
   }

   /*!
    * @brief Getter for xs_string
    * Vendor specific serial number of the device
    */
   const xs_string& getDeviceSerial() const {
      return deviceSerial;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isDeviceSerialSet() const {
      return isSet("deviceSerial");
   }

   /*!
    * @brief Setter for xs_string
    * Human readable name of the device vendor
    */
   void setDeviceVendor(xs_string const &value_) {
      deviceVendor = value_;
      markAsSet("deviceVendor");
   }

   /*!
    * @brief Getter for xs_string
    * Human readable name of the device vendor
    */
   xs_string& getDeviceVendor() {
      return deviceVendor;
   }

   /*!
    * @brief Getter for xs_string
    * Human readable name of the device vendor
    */
   const xs_string& getDeviceVendor() const {
      return deviceVendor;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isDeviceVendorSet() const {
      return isSet("deviceVendor");
   }

   /*!
    * @brief Setter for xs_string
    * Configuration URL of the device.
    */
   void setDeviceURL(xs_string const &value_) {
      deviceURL = value_;
      markAsSet("deviceURL");
   }

   /*!
    * @brief Getter for xs_string
    * Configuration URL of the device.
    */
   xs_string& getDeviceURL() {
      return deviceURL;
   }

   /*!
    * @brief Getter for xs_string
    * Configuration URL of the device.
    */
   const xs_string& getDeviceURL() const {
      return deviceURL;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isDeviceURLSet() const {
      return isSet("deviceURL");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
