#ifndef EM2DEVICE_H_
#define EM2DEVICE_H_

#include "../SEMPCommon.h"
#include "DeviceControl.h"
#include "MessageList.h"

namespace SEMP
{

/*! \class EM2Device
 * This data structure encapsulates all information transmitted by the Energy Management System to the device
 */
class EM2Device : public SEMPObject
{
public:
   EM2Device();
   EM2Device(const EM2Device& rhs);
   EM2Device& operator=(const EM2Device& rhs);
private:
   /*!
    * This element contains load control recommendations for a device.
    */
   std::vector<DeviceControl> deviceControl; /* occurs: 0 .. unbounded */

   /*!
    * This element provides information about an error or event the device should be informed about.
    */
   MessageList messages; /* occurs: 0 .. 1 */


public:
   /*!
    * @brief Setter for DeviceControl
    * This element contains load control recommendations for a device.
    */
   void addDeviceControl(DeviceControl const &value_) {
      deviceControl.push_back(value_);
      markAsSet("deviceControl");
   }

   const std::vector<DeviceControl>& getDeviceControlList() const {
      return deviceControl;
   }

   /*!
    * @brief Getter for DeviceControl
    * This element contains load control recommendations for a device.
    */
   DeviceControl& getDeviceControl(size_t index) {
      return deviceControl[index];
   }

   /*!
    * @brief Getter for DeviceControl
    * This element contains load control recommendations for a device.
    */
   const DeviceControl& getDeviceControl(size_t index) const {
      return deviceControl[index];
   }

   /*!
    * @brief Checks if field DeviceControl is set
    */
   bool isDeviceControlSet() const {
      return isSet("deviceControl");
   }

   /*!
    * @brief Setter for MessageList
    * This element provides information about an error or event the device should be informed about.
    */
   void setMessages(MessageList const &value_) {
      messages = value_;
      messages.setOnSetListener(this, "");
      markAsSet("messages");
   }

   /*!
    * @brief Getter for MessageList
    * This element provides information about an error or event the device should be informed about.
    */
   MessageList& getMessages() {
      return messages;
   }

   /*!
    * @brief Getter for MessageList
    * This element provides information about an error or event the device should be informed about.
    */
   const MessageList& getMessages() const {
      return messages;
   }

   /*!
    * @brief Checks if field MessageList is set
    */
   bool isMessagesSet() const {
      return isSet("messages");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
