#include "EM2Device.h"
#include "../SEMPCommon.h"
#include "DeviceControl.h"
#include "MessageList.h"

namespace SEMP
{

EM2Device::EM2Device()
{
   messages.setOnSetListener(this, "messages");
}


EM2Device::EM2Device(const EM2Device& rhs) :
   SEMPObject(rhs),
   deviceControl(rhs.deviceControl),
   messages(rhs.messages)
{
   messages.setOnSetListener(this, "messages");
}

EM2Device& EM2Device::operator=(const EM2Device& rhs)
{
   if(this != &rhs)
   {
      SEMPObject::operator=(rhs);
      deviceControl = rhs.deviceControl;
      messages = rhs.messages;
      messages.setOnSetListener(this, "messages");
   }
   return *this;
}

void EM2Device::serializeXML(std::stringstream &sstream, int level_) const
{
   sstream << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
   sstream << indentXML(level_++) << "<EM2Device xmlns=\"http://www.sma.de/communication/schema/SEMP/v1\">\n";
   if (isSet("deviceControl")) {
      for (size_t i = 0; i < deviceControl.size(); ++i) {
            sstream << indentXML(level_) << "<DeviceControl>\n";
            deviceControl[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</DeviceControl>\n";
      }
   }
   if (isSet("messages")) {
         sstream << indentXML(level_) << "<Messages>\n";
         messages.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Messages>\n";
   }
   sstream << indentXML(level_-1) << "</EM2Device>\n";
}

bool EM2Device::validateXMLSchema(std::string &errElement_) const
{
   for (size_t i = 0; i < deviceControl.size(); ++i)
      if (!deviceControl[i].validateXMLSchema(errElement_)) { errElement_ = "deviceControl/" + errElement_; return false; }
   if (isSet("messages") && !messages.validateXMLSchema(errElement_)) { errElement_ = "messages/" + errElement_; return false; }
   return true;
}

}
