#ifndef DEVICESTATUS_H_
#define DEVICESTATUS_H_

#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "PowerConsumption.h"

namespace SEMP
{

/*! \class DeviceStatus
 * A DeviceStatus encapsulates the status information of a device, i.e. all measurements and properties representing the current status of the device
 */
class DeviceStatus : public SEMPObject
{
public:
   DeviceStatus();
   DeviceStatus(const DeviceStatus& rhs);
   DeviceStatus& operator=(const DeviceStatus& rhs);
private:
   /*!
    * Unique identification of the device.
    */
   DeviceId deviceId;

   /*!
    * Bool that indicates if the device is currently considering the control signals or recommendations provided by the energy manager or if it is
            in a mode which ignores the signals or recommendations
    */
   xs_bool eMSignalsAccepted;

   /*!
    * String that provides information of the current status of the device (Offline, On, Off).
            See StatusRefType for known values.
    */
   xs_string status;

   /*!
    * Identifies the current error state of the device. If the code is 0, no error is pending.
    */
   xs_int errorCode; /* occurs: 0 .. 1 */

   /*!
    * Information about the current power consumption of the device, or the power consumption of the device since the last communication.
    */
   PowerConsumption powerConsumption; /* occurs: 0 .. 1 */


public:
   /*!
    * @brief Setter for DeviceId
    * Unique identification of the device.
    */
   void setDeviceId(DeviceId const &value_) {
      deviceId = value_;
      markAsSet("deviceId");
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   DeviceId& getDeviceId() {
      return deviceId;
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   const DeviceId& getDeviceId() const {
      return deviceId;
   }

   /*!
    * @brief Checks if field DeviceId is set
    */
   bool isDeviceIdSet() const {
      return isSet("deviceId");
   }

   /*!
    * @brief Setter for xs_bool
    * Bool that indicates if the device is currently considering the control signals or recommendations provided by the energy manager or if it is
            in a mode which ignores the signals or recommendations
    */
   void setEMSignalsAccepted(xs_bool value_) {
      eMSignalsAccepted = value_;
      markAsSet("eMSignalsAccepted");
   }

   /*!
    * @brief Getter for xs_bool
    * Bool that indicates if the device is currently considering the control signals or recommendations provided by the energy manager or if it is
            in a mode which ignores the signals or recommendations
    */
   xs_bool getEMSignalsAccepted() const {
      return eMSignalsAccepted;
   }

   /*!
    * @brief Checks if field xs_bool is set
    */
   bool isEMSignalsAcceptedSet() const {
      return isSet("eMSignalsAccepted");
   }

   /*!
    * @brief Setter for xs_string
    * String that provides information of the current status of the device (Offline, On, Off).
            See StatusRefType for known values.
    */
   void setStatus(xs_string const &value_) {
      status = value_;
      markAsSet("status");
   }

   /*!
    * @brief Getter for xs_string
    * String that provides information of the current status of the device (Offline, On, Off).
            See StatusRefType for known values.
    */
   xs_string& getStatus() {
      return status;
   }

   /*!
    * @brief Getter for xs_string
    * String that provides information of the current status of the device (Offline, On, Off).
            See StatusRefType for known values.
    */
   const xs_string& getStatus() const {
      return status;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isStatusSet() const {
      return isSet("status");
   }

   /*!
    * @brief Setter for xs_int
    * Identifies the current error state of the device. If the code is 0, no error is pending.
    */
   void setErrorCode(xs_int value_) {
      errorCode = value_;
      markAsSet("errorCode");
   }

   /*!
    * @brief Getter for xs_int
    * Identifies the current error state of the device. If the code is 0, no error is pending.
    */
   xs_int getErrorCode() const {
      return errorCode;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isErrorCodeSet() const {
      return isSet("errorCode");
   }

   /*!
    * @brief Setter for PowerConsumption
    * Information about the current power consumption of the device, or the power consumption of the device since the last communication.
    */
   void setPowerConsumption(PowerConsumption const &value_) {
      powerConsumption = value_;
      powerConsumption.setOnSetListener(this, "");
      markAsSet("powerConsumption");
   }

   /*!
    * @brief Getter for PowerConsumption
    * Information about the current power consumption of the device, or the power consumption of the device since the last communication.
    */
   PowerConsumption& getPowerConsumption() {
      return powerConsumption;
   }

   /*!
    * @brief Getter for PowerConsumption
    * Information about the current power consumption of the device, or the power consumption of the device since the last communication.
    */
   const PowerConsumption& getPowerConsumption() const {
      return powerConsumption;
   }

   /*!
    * @brief Checks if field PowerConsumption is set
    */
   bool isPowerConsumptionSet() const {
      return isSet("powerConsumption");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
