#include "DeviceStatus.h"
#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "PowerConsumption.h"

namespace SEMP
{

DeviceStatus::DeviceStatus() :
   eMSignalsAccepted(DEFAULT_VALUE_XS_BOOL),
   errorCode(DEFAULT_VALUE_XS_INT)
{
   powerConsumption.setOnSetListener(this, "powerConsumption");
}


DeviceStatus::DeviceStatus(const DeviceStatus& rhs) :
   SEMPObject(rhs),
   deviceId(rhs.deviceId),
   eMSignalsAccepted(rhs.eMSignalsAccepted),
   status(rhs.status),
   errorCode(rhs.errorCode),
   powerConsumption(rhs.powerConsumption)
{
   powerConsumption.setOnSetListener(this, "powerConsumption");
}

DeviceStatus& DeviceStatus::operator=(const DeviceStatus& rhs)
{
   if(this != &rhs)
   {
      SEMPObject::operator=(rhs);
      deviceId = rhs.deviceId;
      eMSignalsAccepted = rhs.eMSignalsAccepted;
      status = rhs.status;
      errorCode = rhs.errorCode;
      powerConsumption = rhs.powerConsumption;
      powerConsumption.setOnSetListener(this, "powerConsumption");
   }
   return *this;
}

void DeviceStatus::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("deviceId")) {
         sstream << indentXML(level_) << "<DeviceId>";
         sstream << deviceId;
         sstream << "</DeviceId>\n";
   }
   if (isSet("eMSignalsAccepted")) {
         sstream << indentXML(level_) << "<EMSignalsAccepted>";
         sstream << std::boolalpha << eMSignalsAccepted << std::noboolalpha;
         sstream << "</EMSignalsAccepted>\n";
   }
   if (isSet("status")) {
         sstream << indentXML(level_) << "<Status>";
         sstream << escapeString(status);
         sstream << "</Status>\n";
   }
   if (isSet("errorCode")) {
         sstream << indentXML(level_) << "<ErrorCode>";
         sstream << errorCode;
         sstream << "</ErrorCode>\n";
   }
   if (isSet("powerConsumption")) {
         sstream << indentXML(level_) << "<PowerConsumption>\n";
         powerConsumption.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</PowerConsumption>\n";
   }
}

bool DeviceStatus::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("deviceId")) { errElement_ = "deviceId"; return false; }
   if (!isSet("eMSignalsAccepted")) { errElement_ = "eMSignalsAccepted"; return false; }
   if (!isSet("status")) { errElement_ = "status"; return false; }
   if (isSet("powerConsumption") && !powerConsumption.validateXMLSchema(errElement_)) { errElement_ = "powerConsumption/" + errElement_; return false; }
   return true;
}

}
