#include "DeviceInfo.h"
#include "../SEMPCommon.h"
#include "Identification.h"
#include "Characteristics.h"
#include "Capabilities.h"

namespace SEMP
{

DeviceInfo::DeviceInfo()
{
   identification.setOnSetListener(this, "identification");
   characteristics.setOnSetListener(this, "characteristics");
   capabilities.setOnSetListener(this, "capabilities");
}


DeviceInfo::DeviceInfo(const DeviceInfo& rhs) :
   SEMPObject(rhs),
   identification(rhs.identification),
   characteristics(rhs.characteristics),
   capabilities(rhs.capabilities)
{
   identification.setOnSetListener(this, "identification");
   characteristics.setOnSetListener(this, "characteristics");
   capabilities.setOnSetListener(this, "capabilities");
}

DeviceInfo& DeviceInfo::operator=(const DeviceInfo& rhs)
{
   if(this != &rhs)
   {
      SEMPObject::operator=(rhs);
      identification = rhs.identification;
      identification.setOnSetListener(this, "identification");
      characteristics = rhs.characteristics;
      characteristics.setOnSetListener(this, "characteristics");
      capabilities = rhs.capabilities;
      capabilities.setOnSetListener(this, "capabilities");
   }
   return *this;
}

void DeviceInfo::serializeXML(std::stringstream &sstream, int level_) const
{
   {
         sstream << indentXML(level_) << "<Identification>\n";
         identification.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Identification>\n";
   }
   {
         sstream << indentXML(level_) << "<Characteristics>\n";
         characteristics.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Characteristics>\n";
   }
   {
         sstream << indentXML(level_) << "<Capabilities>\n";
         capabilities.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Capabilities>\n";
   }
}

bool DeviceInfo::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("identification")) { errElement_ = "identification"; return false; }
   if (isSet("identification") && !identification.validateXMLSchema(errElement_)) { errElement_ = "identification/" + errElement_; return false; }
   if (!isSet("characteristics")) { errElement_ = "characteristics"; return false; }
   if (isSet("characteristics") && !characteristics.validateXMLSchema(errElement_)) { errElement_ = "characteristics/" + errElement_; return false; }
   if (!isSet("capabilities")) { errElement_ = "capabilities"; return false; }
   if (isSet("capabilities") && !capabilities.validateXMLSchema(errElement_)) { errElement_ = "capabilities/" + errElement_; return false; }
   return true;
}

}
