#ifndef DEVICECONTROL_H_
#define DEVICECONTROL_H_

#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

/*! \class DeviceControl
 * Contains operation and power consumption recommendations for a device.
 */
class DeviceControl : public SEMPObject
{
public:
   DeviceControl();
private:
   /*!
    * Unique identification of the device.
    */
   DeviceId deviceId;

   /*!
    * Switch on/off recommendation.
            If On=true, the EM recommends that the device should be switched on or run its program.
            For interruptible devices On=false is a switch-off recommendation indicating that the device should switch off or pause.
            A device should follow the recommendation as soon as possible. Otherwise the device might interfere with other devices 
            managed by the EM.
            Note that the device should only accept a recommendation if stable operation is guaranteed (no risk of damage or safety issues).
    */
   xs_bool on;

   /*!
    * Reserved for future use.
    */
   xs_double recommendedPowerConsumption; /* occurs: 0 .. 1 */

   /*!
    * Timestamp of the generation of the message. 
            Note that this does not determine the activation time of the switch-on or power recommendation. Recommendations are supposed to be applied immediately by the device.
    */
   RelOrAbsTime timestamp;


public:
   /*!
    * @brief Setter for DeviceId
    * Unique identification of the device.
    */
   void setDeviceId(DeviceId const &value_) {
      deviceId = value_;
      markAsSet("deviceId");
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   DeviceId& getDeviceId() {
      return deviceId;
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   const DeviceId& getDeviceId() const {
      return deviceId;
   }

   /*!
    * @brief Checks if field DeviceId is set
    */
   bool isDeviceIdSet() const {
      return isSet("deviceId");
   }

   /*!
    * @brief Setter for xs_bool
    * Switch on/off recommendation.
            If On=true, the EM recommends that the device should be switched on or run its program.
            For interruptible devices On=false is a switch-off recommendation indicating that the device should switch off or pause.
            A device should follow the recommendation as soon as possible. Otherwise the device might interfere with other devices 
            managed by the EM.
            Note that the device should only accept a recommendation if stable operation is guaranteed (no risk of damage or safety issues).
    */
   void setOn(xs_bool value_) {
      on = value_;
      markAsSet("on");
   }

   /*!
    * @brief Getter for xs_bool
    * Switch on/off recommendation.
            If On=true, the EM recommends that the device should be switched on or run its program.
            For interruptible devices On=false is a switch-off recommendation indicating that the device should switch off or pause.
            A device should follow the recommendation as soon as possible. Otherwise the device might interfere with other devices 
            managed by the EM.
            Note that the device should only accept a recommendation if stable operation is guaranteed (no risk of damage or safety issues).
    */
   xs_bool getOn() const {
      return on;
   }

   /*!
    * @brief Checks if field xs_bool is set
    */
   bool isOnSet() const {
      return isSet("on");
   }

   /*!
    * @brief Setter for xs_double
    * Reserved for future use.
    */
   void setRecommendedPowerConsumption(xs_double value_) {
      recommendedPowerConsumption = value_;
      markAsSet("recommendedPowerConsumption");
   }

   /*!
    * @brief Getter for xs_double
    * Reserved for future use.
    */
   xs_double getRecommendedPowerConsumption() const {
      return recommendedPowerConsumption;
   }

   /*!
    * @brief Checks if field xs_double is set
    */
   bool isRecommendedPowerConsumptionSet() const {
      return isSet("recommendedPowerConsumption");
   }

   /*!
    * @brief Setter for RelOrAbsTime
    * Timestamp of the generation of the message. 
            Note that this does not determine the activation time of the switch-on or power recommendation. Recommendations are supposed to be applied immediately by the device.
    */
   void setTimestamp(RelOrAbsTime const &value_) {
      timestamp = value_;
      markAsSet("timestamp");
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Timestamp of the generation of the message. 
            Note that this does not determine the activation time of the switch-on or power recommendation. Recommendations are supposed to be applied immediately by the device.
    */
   RelOrAbsTime& getTimestamp() {
      return timestamp;
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Timestamp of the generation of the message. 
            Note that this does not determine the activation time of the switch-on or power recommendation. Recommendations are supposed to be applied immediately by the device.
    */
   const RelOrAbsTime& getTimestamp() const {
      return timestamp;
   }

   /*!
    * @brief Checks if field RelOrAbsTime is set
    */
   bool isTimestampSet() const {
      return isSet("timestamp");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
