#include "DeviceControl.h"
#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

DeviceControl::DeviceControl() :
   on(DEFAULT_VALUE_XS_BOOL),
   recommendedPowerConsumption(DEFAULT_VALUE_XS_DOUBLE)
{
}


void DeviceControl::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("deviceId")) {
         sstream << indentXML(level_) << "<DeviceId>";
         sstream << deviceId;
         sstream << "</DeviceId>\n";
   }
   if (isSet("on")) {
         sstream << indentXML(level_) << "<On>";
         sstream << std::boolalpha << on << std::noboolalpha;
         sstream << "</On>\n";
   }
   if (isSet("recommendedPowerConsumption")) {
         sstream << indentXML(level_) << "<RecommendedPowerConsumption>";
         sstream << recommendedPowerConsumption;
         sstream << "</RecommendedPowerConsumption>\n";
   }
   if (isSet("timestamp")) {
         sstream << indentXML(level_) << "<Timestamp>";
         sstream << timestamp;
         sstream << "</Timestamp>\n";
   }
}

bool DeviceControl::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("deviceId")) { errElement_ = "deviceId"; return false; }
   if (!isSet("on")) { errElement_ = "on"; return false; }
   if (!isSet("timestamp")) { errElement_ = "timestamp"; return false; }
   return true;
}

}
