#ifndef DEVICE2EM_H_
#define DEVICE2EM_H_

#include "../SEMPCommon.h"
#include "DeviceInfo.h"
#include "DeviceStatus.h"
#include "PlanningRequest.h"

namespace SEMP
{

/*! \class Device2EM
 * This data structure encapsulates all information transmitted by the device to the Energy Management System
 */
class Device2EM : public SEMPObject
{
public:
   Device2EM();
private:
   /*!
    * A DeviceInfo encapsulates all static information about a device such as identification, capabilities, restrictions, etc.
    */
   std::vector<DeviceInfo> deviceInfo; /* occurs: 0 .. unbounded */

   /*!
    * A DeviceStatus encapsulates the status information of a device, i.e. all measurements and properties representing the current status of the device
    */
   std::vector<DeviceStatus> deviceStatus; /* occurs: 0 .. unbounded */

   /*!
    * A PlanningRequest allows specification of the needs of the device with regard to energy and running time.
              As long as an energy need is pending, the gateway has to announce them in terms of PlanningRequests.
              PlanningRequests are not incremental, i.e. requests that sent to the EM in previous messages are discarded
              and replaced by the newest PlanningRequests. Missing timeframes or an empty PlanningRequest list are interpreted
              as if the energy needs are already satisfied.
    */
   std::vector<PlanningRequest> planningRequest; /* occurs: 0 .. unbounded */


public:
   /*!
    * @brief Setter for DeviceInfo
    * A DeviceInfo encapsulates all static information about a device such as identification, capabilities, restrictions, etc.
    */
   void addDeviceInfo(DeviceInfo const &value_) {
      deviceInfo.push_back(value_);
      markAsSet("deviceInfo");
   }

   const std::vector<DeviceInfo>& getDeviceInfoList() const {
      return deviceInfo;
   }

   /*!
    * @brief Getter for DeviceInfo
    * A DeviceInfo encapsulates all static information about a device such as identification, capabilities, restrictions, etc.
    */
   DeviceInfo& getDeviceInfo(size_t index) {
      return deviceInfo[index];
   }

   /*!
    * @brief Getter for DeviceInfo
    * A DeviceInfo encapsulates all static information about a device such as identification, capabilities, restrictions, etc.
    */
   const DeviceInfo& getDeviceInfo(size_t index) const {
      return deviceInfo[index];
   }

   /*!
    * @brief Checks if field DeviceInfo is set
    */
   bool isDeviceInfoSet() const {
      return isSet("deviceInfo");
   }

   /*!
    * @brief Setter for DeviceStatus
    * A DeviceStatus encapsulates the status information of a device, i.e. all measurements and properties representing the current status of the device
    */
   void addDeviceStatus(DeviceStatus const &value_) {
      deviceStatus.push_back(value_);
      markAsSet("deviceStatus");
   }

   const std::vector<DeviceStatus>& getDeviceStatusList() const {
      return deviceStatus;
   }

   /*!
    * @brief Getter for DeviceStatus
    * A DeviceStatus encapsulates the status information of a device, i.e. all measurements and properties representing the current status of the device
    */
   DeviceStatus& getDeviceStatus(size_t index) {
      return deviceStatus[index];
   }

   /*!
    * @brief Getter for DeviceStatus
    * A DeviceStatus encapsulates the status information of a device, i.e. all measurements and properties representing the current status of the device
    */
   const DeviceStatus& getDeviceStatus(size_t index) const {
      return deviceStatus[index];
   }

   /*!
    * @brief Checks if field DeviceStatus is set
    */
   bool isDeviceStatusSet() const {
      return isSet("deviceStatus");
   }

   /*!
    * @brief Setter for PlanningRequest
    * A PlanningRequest allows specification of the needs of the device with regard to energy and running time.
              As long as an energy need is pending, the gateway has to announce them in terms of PlanningRequests.
              PlanningRequests are not incremental, i.e. requests that sent to the EM in previous messages are discarded
              and replaced by the newest PlanningRequests. Missing timeframes or an empty PlanningRequest list are interpreted
              as if the energy needs are already satisfied.
    */
   void addPlanningRequest(PlanningRequest const &value_) {
      planningRequest.push_back(value_);
      markAsSet("planningRequest");
   }

   const std::vector<PlanningRequest>& getPlanningRequestList() const {
      return planningRequest;
   }

   /*!
    * @brief Getter for PlanningRequest
    * A PlanningRequest allows specification of the needs of the device with regard to energy and running time.
              As long as an energy need is pending, the gateway has to announce them in terms of PlanningRequests.
              PlanningRequests are not incremental, i.e. requests that sent to the EM in previous messages are discarded
              and replaced by the newest PlanningRequests. Missing timeframes or an empty PlanningRequest list are interpreted
              as if the energy needs are already satisfied.
    */
   PlanningRequest& getPlanningRequest(size_t index) {
      return planningRequest[index];
   }

   /*!
    * @brief Getter for PlanningRequest
    * A PlanningRequest allows specification of the needs of the device with regard to energy and running time.
              As long as an energy need is pending, the gateway has to announce them in terms of PlanningRequests.
              PlanningRequests are not incremental, i.e. requests that sent to the EM in previous messages are discarded
              and replaced by the newest PlanningRequests. Missing timeframes or an empty PlanningRequest list are interpreted
              as if the energy needs are already satisfied.
    */
   const PlanningRequest& getPlanningRequest(size_t index) const {
      return planningRequest[index];
   }

   /*!
    * @brief Checks if field PlanningRequest is set
    */
   bool isPlanningRequestSet() const {
      return isSet("planningRequest");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
