#include "Device2EM.h"
#include "../SEMPCommon.h"
#include "DeviceInfo.h"
#include "DeviceStatus.h"
#include "PlanningRequest.h"

namespace SEMP
{

Device2EM::Device2EM()
{
}


void Device2EM::serializeXML(std::stringstream &sstream, int level_) const
{
   sstream << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
   sstream << indentXML(level_++) << "<Device2EM xmlns=\"http://www.sma.de/communication/schema/SEMP/v1\">\n";
   if (isSet("deviceInfo")) {
      for (size_t i = 0; i < deviceInfo.size(); ++i) {
            sstream << indentXML(level_) << "<DeviceInfo>\n";
            deviceInfo[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</DeviceInfo>\n";
      }
   }
   if (isSet("deviceStatus")) {
      for (size_t i = 0; i < deviceStatus.size(); ++i) {
            sstream << indentXML(level_) << "<DeviceStatus>\n";
            deviceStatus[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</DeviceStatus>\n";
      }
   }
   if (isSet("planningRequest")) {
      for (size_t i = 0; i < planningRequest.size(); ++i) {
            sstream << indentXML(level_) << "<PlanningRequest>\n";
            planningRequest[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</PlanningRequest>\n";
      }
   }
   sstream << indentXML(level_-1) << "</Device2EM>\n";
}

bool Device2EM::validateXMLSchema(std::string &errElement_) const
{
   for (size_t i = 0; i < deviceInfo.size(); ++i)
      if (!deviceInfo[i].validateXMLSchema(errElement_)) { errElement_ = "deviceInfo/" + errElement_; return false; }
   for (size_t i = 0; i < deviceStatus.size(); ++i)
      if (!deviceStatus[i].validateXMLSchema(errElement_)) { errElement_ = "deviceStatus/" + errElement_; return false; }
   for (size_t i = 0; i < planningRequest.size(); ++i)
      if (!planningRequest[i].validateXMLSchema(errElement_)) { errElement_ = "planningRequest/" + errElement_; return false; }
   return true;
}

}
