#include "Capabilities.h"
#include "../SEMPCommon.h"
#include "CapPowerMeasurement.h"
#include "CapTimestamp.h"
#include "CapInterruptions.h"
#include "CapRequests.h"

namespace SEMP
{

Capabilities::Capabilities()
{
   currentPower.setOnSetListener(this, "currentPower");
   timestamps.setOnSetListener(this, "timestamps");
   interruptions.setOnSetListener(this, "interruptions");
   requests.setOnSetListener(this, "requests");
}


Capabilities::Capabilities(const Capabilities& rhs) :
   SEMPObject(rhs),
   currentPower(rhs.currentPower),
   timestamps(rhs.timestamps),
   interruptions(rhs.interruptions),
   requests(rhs.requests)
{
   currentPower.setOnSetListener(this, "currentPower");
   timestamps.setOnSetListener(this, "timestamps");
   interruptions.setOnSetListener(this, "interruptions");
   requests.setOnSetListener(this, "requests");
}

Capabilities& Capabilities::operator=(const Capabilities& rhs)
{
   if(this != &rhs)
   {
      SEMPObject::operator=(rhs);
      currentPower = rhs.currentPower;
      currentPower.setOnSetListener(this, "currentPower");
      timestamps = rhs.timestamps;
      timestamps.setOnSetListener(this, "timestamps");
      interruptions = rhs.interruptions;
      interruptions.setOnSetListener(this, "interruptions");
      requests = rhs.requests;
      requests.setOnSetListener(this, "requests");
   }
   return *this;
}

void Capabilities::serializeXML(std::stringstream &sstream, int level_) const
{
   {
         sstream << indentXML(level_) << "<CurrentPower>\n";
         currentPower.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</CurrentPower>\n";
   }
   if (isSet("timestamps")) {
         sstream << indentXML(level_) << "<Timestamps>\n";
         timestamps.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Timestamps>\n";
   }
   if (isSet("interruptions")) {
         sstream << indentXML(level_) << "<Interruptions>\n";
         interruptions.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Interruptions>\n";
   }
   if (isSet("requests")) {
         sstream << indentXML(level_) << "<Requests>\n";
         requests.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Requests>\n";
   }
}

bool Capabilities::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("currentPower")) { errElement_ = "currentPower"; return false; }
   if (isSet("currentPower") && !currentPower.validateXMLSchema(errElement_)) { errElement_ = "currentPower/" + errElement_; return false; }
   if (isSet("timestamps") && !timestamps.validateXMLSchema(errElement_)) { errElement_ = "timestamps/" + errElement_; return false; }
   if (isSet("interruptions") && !interruptions.validateXMLSchema(errElement_)) { errElement_ = "interruptions/" + errElement_; return false; }
   if (isSet("requests") && !requests.validateXMLSchema(errElement_)) { errElement_ = "requests/" + errElement_; return false; }
   return true;
}

}
