#ifndef CAPTIMESTAMP_H_
#define CAPTIMESTAMP_H_

#include "../SEMPCommon.h"

namespace SEMP
{

/*! \class CapTimestamp
 * Specifies if the device is able to deal with absolute timestamps or only with relative timestamps
 */
class CapTimestamp : public SEMPObject
{
public:
   CapTimestamp();
private:
   /*!
    * Bool that indicates if the device is able to deal with absolute timestamps or only with relative timestamps
    */
   xs_bool absoluteTimestamps;


public:
   /*!
    * @brief Setter for xs_bool
    * Bool that indicates if the device is able to deal with absolute timestamps or only with relative timestamps
    */
   void setAbsoluteTimestamps(xs_bool value_) {
      absoluteTimestamps = value_;
      markAsSet("absoluteTimestamps");
   }

   /*!
    * @brief Getter for xs_bool
    * Bool that indicates if the device is able to deal with absolute timestamps or only with relative timestamps
    */
   xs_bool getAbsoluteTimestamps() const {
      return absoluteTimestamps;
   }

   /*!
    * @brief Checks if field xs_bool is set
    */
   bool isAbsoluteTimestampsSet() const {
      return isSet("absoluteTimestamps");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
