#include "CapRequests.h"
#include "../SEMPCommon.h"

namespace SEMP
{

CapRequests::CapRequests() :
   optionalEnergy(false)
{
}


void CapRequests::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("optionalEnergy")) {
         sstream << indentXML(level_) << "<OptionalEnergy>";
         sstream << std::boolalpha << optionalEnergy << std::noboolalpha;
         sstream << "</OptionalEnergy>\n";
   }
}

bool CapRequests::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("optionalEnergy")) { errElement_ = "optionalEnergy"; return false; }
   return true;
}

}
