#ifndef CAPPOWERMEASUREMENT_H_
#define CAPPOWERMEASUREMENT_H_

#include "../SEMPCommon.h"

namespace SEMP
{

/*! \class CapPowerMeasurement
 * Capability of the device with regard to deriving information about its current power consumption, e.g. measurement or estimation
 */
class CapPowerMeasurement : public SEMPObject
{
public:
   CapPowerMeasurement();
private:
   /*!
    * 
    */
   xs_string method;


public:
   /*!
    * @brief Setter for xs_string
    * 
    */
   void setMethod(xs_string const &value_) {
      method = value_;
      markAsSet("method");
   }

   /*!
    * @brief Getter for xs_string
    * 
    */
   xs_string& getMethod() {
      return method;
   }

   /*!
    * @brief Getter for xs_string
    * 
    */
   const xs_string& getMethod() const {
      return method;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isMethodSet() const {
      return isSet("method");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
