#ifndef CAPINTERRUPTIONS_H_
#define CAPINTERRUPTIONS_H_

#include "../SEMPCommon.h"

namespace SEMP
{

/*! \class CapInterruptions
 * Specifies if a run of the device can be interrupted or not.
 */
class CapInterruptions : public SEMPObject
{
public:
   CapInterruptions();
private:
   /*!
    * 
    */
   xs_bool interruptionsAllowed;


public:
   /*!
    * @brief Setter for xs_bool
    * 
    */
   void setInterruptionsAllowed(xs_bool value_) {
      interruptionsAllowed = value_;
      markAsSet("interruptionsAllowed");
   }

   /*!
    * @brief Getter for xs_bool
    * 
    */
   xs_bool getInterruptionsAllowed() const {
      return interruptionsAllowed;
   }

   /*!
    * @brief Checks if field xs_bool is set
    */
   bool isInterruptionsAllowedSet() const {
      return isSet("interruptionsAllowed");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
