#include "CapInterruptions.h"
#include "../SEMPCommon.h"

namespace SEMP
{

CapInterruptions::CapInterruptions() :
   interruptionsAllowed(false)
{
}


void CapInterruptions::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("interruptionsAllowed")) {
         sstream << indentXML(level_) << "<InterruptionsAllowed>";
         sstream << std::boolalpha << interruptionsAllowed << std::noboolalpha;
         sstream << "</InterruptionsAllowed>\n";
   }
}

bool CapInterruptions::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("interruptionsAllowed")) { errElement_ = "interruptionsAllowed"; return false; }
   return true;
}

}
