/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef HTTPCLIENT_H_
#define HTTPCLIENT_H_

#include <netinet/in.h>
#include <arpa/inet.h>
#include "HTTPCommon.h"
#include "base/PropertyMap.h"

class HTTPResponseHeaderBuffer : public HTTPMessageHeaderBuffer
{
public:
   int getStatusCode() const;
};

struct HTTPRequestHeader
{
   HTTPMethod method;
   propertyMap_t fields;

   HTTPRequestHeader(HTTPMethod method_) :
      method(method_) {}
};

/*! @class HTTPClient
 *
 * @brief A HTTPClient is a simple HTTP client to retrieve data from a webserver.
 */
class HTTPClient
{
public:
   /**
   * @brief constructor
   */
   HTTPClient();

   /**
   * @brief Retrieves the contents of the url
   *
   * The data is splitted into header and body and get be accessed via getResponseHeader() or getResponseBody()
   *
   * @param method the HTTP method used for retrieving data (either GET or POST)
   * @param url the requested URL
   * @param body the content send to the server if method POST is used
   *
   * @return 0 on success
   */
   int performRequest(HTTPMethod method, const std::string &url, const std::string &body = "") {
      return performRequest(HTTPRequestHeader(method), url, body);
   }

   int performRequest(const HTTPRequestHeader &header, const std::string &url, const std::string &body = "");

   /**
   * @brief Returns the header received from the last request
   * @return the header received from the last request
   */
   const HTTPResponseHeaderBuffer& getResponseHeader() { return _header; }

   /**
   * @brief Returns the body received from the last request
   * @return the body received from the last request
   */
   const std::string& getResponseBody() { return _body; }

   void setTimeout(time_t timeout) {
      _timeout = timeout;
   }

   time_t getTimeout() {
      return _timeout;
   }

   /**
   * @brief Resets the internal state
   */
   void reset();

private:
   /**
   * @brief the HTTP header received from the last request
   */
   HTTPResponseHeaderBuffer _header;

   /**
   * @brief the HTTP body received from the last request
   */
   std::string _body;

   time_t _timeout;

   int openSocket(const struct sockaddr *dstAddr, socklen_t dstAddrSize);
   bool sendRequest(int sock, const std::string &request);
};

#endif
