/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef UDPSOCKET_H_
#define UDPSOCKET_H_

#include <netinet/in.h>

/*! @class UDPSocket
 *
 * @brief This class encapsulates a UDP socket
  */
class UDPSocket {
public:
   /*!
   * @brief constructor
   */
   UDPSocket();

   /*!
   * @brief destructor
   */
   virtual ~UDPSocket();

   /*!
   * @brief Sets the destination address and port
   *
   * @param dstAddr the destination address
   * @param port the destination port
   */
   void setDestination(const char *dstAddr, int port);

   /*!
   * @brief Sets the destination address and port
   *
   * @param dstAddr the destination address
   */
   void setDestination(const sockaddr_in &dstAddr);

   /*!
   * @brief Sends data to the destination
   *
   * @param buffer the data to send
   * @param length the data length
   */
   ssize_t send(const char* buffer, size_t length);

   /*!
   * @brief Receive data from destination
   *
   * @param buffer the buffer used to store the received data
   * @param length the buffer length
   */
   ssize_t receive(char* buffer, size_t length);

private:

   /*!
   * @brief socket that is used for sending the UDP packets
   */
	int _socket;

   /*!
    * @brief holds destination address information, port and ip-address.
    */
   sockaddr_in _dstAddr;
};


#endif
