/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef TIMEHELPER_H_
#define TIMEHELPER_H_

#include <time.h>
#include <sstream>
#include "StringHelper.h"

// timestamp could be relative or absolute -> negative values possible
typedef int64_t timestamp_t;

/*! @class Time
 *
 * @brief Contains time helper functions.
 */
class Time
{
public:
   /*!
    * @brief Returns the absolute current time in seconds.
    */
   static timestamp_t getCurrentTime() {
      return time(NULL);
   }

   /*!
    * @brief Returns the time difference between time2 and time1 (time2 - time1).
    */
   static double getTimeDiff(const timestamp_t &time2, const timestamp_t &time1) {
      // Note: special function difftime(time2, time1) not needed for signed timestamps
      return time2 - time1;
   }

   /*!
    * @brief Returns the ASCII or C-time representation of absolute timestamp @p t.
    */
   static std::string toASCIITime(const timestamp_t &t) {
      time_t tt = (time_t)t;
      char* str = ctime(&tt);
      if (!str)
         return "";
      return StringHelper::rstrip(str);
   }

   static std::string toString(timestamp_t t) {
      std::stringstream ss;
      ss << t;
      return ss.str();
   }
};

#endif
