/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef THREAD_H_
#define THREAD_H_

#include <pthread.h>
#include <sys/sem.h>
#include <sys/types.h>
#include <sys/ipc.h>


/*! @class Thread
 *  \brief Wrapper class for pthread.
 */
class Thread {

public:
   //!\brief constructor
   Thread();

   //!\brief destructor
   virtual ~Thread();

   //!\brief lock mutex
   void setDataLock();

   //!\brief unlock mutex
   void unsetDataLock();

   //!\brief create and detach thread
   void start();

   void abort(int timeout = -1);

   bool isAborted();

   //!\brief returns true if thread is running
   bool isRunning();

private:

   //!\brief mutex of this thread
   pthread_mutex_t dataLock;

   //!\brief thread is made asynchronously cancelable
   static void * threadFunction(void * arg);

   //!\brief tracks if thread is started
   bool running;

   bool aborted;

   //!\brief thread id
   pthread_t threadId;

protected:

   //!\brief abstract class to be implemented for the specific thread to run
   virtual void run() = 0;
};

#endif
