/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#include "StringHelper.h"
#include <algorithm>
#include <fstream>
#include <sys/types.h>
#include <strings.h>

void StringHelper::split(const std::string &str, const std::string &delims, std::vector<std::string> &result,
      bool groupDelimSequence, int maxTokenCnt)
{
   if (str.size() == 0 || delims.size() == 0) {
      result.push_back(str);
      return;
   }

   size_t delimPos;
   size_t lastPos = 0;
   while ((lastPos < str.size()) &&
          ((delimPos = str.find_first_of(delims, lastPos)) != std::string::npos) &&
          (maxTokenCnt < 1 || result.size() < (uint)maxTokenCnt-1))
   {
      if (!groupDelimSequence || (delimPos - lastPos > 0)) {
         result.push_back(str.substr(lastPos, delimPos - lastPos));
      }
      lastPos = delimPos + 1;
   }
   if (lastPos < str.size())
      result.push_back(str.substr(lastPos, str.size() - lastPos));
}

std::string StringHelper::lstrip(const std::string &str)
{
   size_t first = str.find_first_not_of(" \t\n\r");
   if (first != std::string::npos)
      return str.substr(first);
   return str;
}

std::string StringHelper::rstrip(const std::string &str)
{
   size_t last = str.find_last_not_of(" \t\n\r");
   if (last != std::string::npos)
      return str.substr(0, last+1);
   else
      return "";
}

std::string StringHelper::strip(const std::string &str)
{
   size_t first = str.find_first_not_of(" \t\n\r");
   if (first == std::string::npos)
      return "";
   // note: at least one non-whitespace exists
   size_t last = str.find_last_not_of(" \t\n\r");
   return str.substr(first, last+1 - first);
}

bool StringHelper::startsWith(const std::string &str, const std::string &start)
{
   return (str.compare(0, start.size(), start) == 0);
}

bool StringHelper::endsWith(const std::string &str, const std::string &end)
{
   if (str.size() < end.size())
      return false;
   return (str.compare(str.size() - end.size(), end.size(), end) == 0);
}

std::string StringHelper::toLower(std::string str)
{
   std::transform(str.begin(),str.end(),str.begin(),::tolower);
   return str;
}

std::string StringHelper::toUpper(std::string str)
{
   std::transform(str.begin(), str.end(), str.begin(), ::toupper);
   return str;
}

size_t StringHelper::extract(const std::string &str, const std::string &prefix, const std::string &suffix, std::string &result, size_t pos)
{
   size_t startPos = str.find(prefix, pos);
   if (startPos != std::string::npos)
   {
      startPos += prefix.size();
      size_t endPos = str.find(suffix, startPos);
      if (endPos != std::string::npos)
      {
         result = str.substr(startPos, endPos - startPos);
         return endPos + suffix.size();
      }
   }
   return std::string::npos;
}

std::string& StringHelper::replace(std::string &str, const std::string &substr, const std::string &replacement, bool global)
{
   size_t pos;
   while ((pos = str.find(substr)) != std::string::npos) {
       str.replace(pos, substr.size(), replacement);
       if (!global)
          break;
   }
   return str;
}

int StringHelper::compareIgnoreCase(const std::string &str1, const std::string &str2) {
#if 0
   if (strlen(str1.c_str()) != strlen(str2.c_str()))
      return 1;
   int i_=0;
   while (str1[i_]) {
      if (!str2[i_]) {
         return 1;
      }
      if (tolower(str1[i_])!=tolower(str2[i_])) {
         return -1;
      }
      i_++;
   }
   return 0;
#else
   return strcasecmp(str1.c_str(), str2.c_str());
#endif
};

bool StringHelper::readFromFile(const std::string &filename, std::string &buffer)
{
    std::ifstream in;
    in.open(filename.c_str(), std::ifstream::in);
    if (!in)
       return false;

    // preallocate space
    in.seekg(0, std::ios::end);
    buffer.reserve(in.tellg());
    in.seekg(0, std::ios::beg);

    buffer.assign((std::istreambuf_iterator<char>(in)),
            std::istreambuf_iterator<char>());
    in.close();
    return true;
}

