/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef NETWORKHELPER_H_
#define NETWORKHELPER_H_

#include <arpa/inet.h>

namespace NetworkHelper {
   bool networkAddrToString(const struct in_addr &addr, std::string &str) {
      // note: inet_ntoa() is not thread-safe, use inet_ntop()
      char gatewayAddrBuffer[INET_ADDRSTRLEN];
      // note: inet_ntoa() is not thread-safe, use inet_ntop()
      if (!inet_ntop(AF_INET, &addr, gatewayAddrBuffer, sizeof(gatewayAddrBuffer))) {
         str = "";
         return false;
      }
      str = std::string(gatewayAddrBuffer);
      return true;
   }

   void getMulticastIfAddr(int sock, struct in_addr &ifAddr) {
      socklen_t len = sizeof(ifAddr);
      memset(&ifAddr, 0, sizeof(ifAddr));
      if (getsockopt(sock, IPPROTO_IP, IP_MULTICAST_IF, &ifAddr, &len) < 0) {
         perror("getsockopt(IP_MULTICAST_IF) failed");
         return;
      }
   }
}


#endif /* NETWORKHELPER_H_ */
