/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef MUTEX_H_
#define MUTEX_H_

#include <pthread.h>
#include "Uncopyable.h"

class Mutex : private Uncopyable
{
public:
   Mutex() {
      pthread_mutexattr_t mattrib;
      pthread_mutexattr_init(&mattrib);
      if (pthread_mutexattr_settype(&mattrib, PTHREAD_MUTEX_RECURSIVE) != 0)
         std::cout << "Mutex: setting recursive mutex type failed" << std::endl;
      pthread_mutex_init(&_mutex, &mattrib);
   }

   ~Mutex() {
      pthread_mutex_destroy(&_mutex);
   }

   void lock() {
      pthread_mutex_lock(&_mutex);
   }

   void unlock() {
      pthread_mutex_unlock(&_mutex);
   }

private:
   pthread_mutex_t _mutex;
};

class ScopedLock
{
public:
   ScopedLock(Mutex &mutex) :
      _mutex(mutex)
   {
      _mutex.lock();
   }

   ~ScopedLock()
   {
      _mutex.unlock();
   }

private:
   Mutex &_mutex;
};

#endif /* MUTEX_H_ */
