/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#include <iostream>
#include "Logger.h"

std::ostream *Logger::_stream = &std::cout;

void Logger::setOStream(std::ostream &stream) {
   _stream = &stream;
}

std::ostream& Logger::log(bool header, LogLevel level) {
   std::string levelStr;
   switch (level) {
   case Info:  levelStr = "Info"; break;
   case Warn:  levelStr = "Warn"; break;
   case Error: levelStr = "Error"; break;
   default:
      levelStr = ""; break;
   }
   return *_stream;
}
