/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef SEMPCOMMON_H_
#define SEMPCOMMON_H_

#include "ISEMPObject.h"
#include <stdint.h>
#include <limits.h>

typedef bool xs_bool;
typedef int xs_int;
typedef unsigned int xs_uint;
typedef int64_t xs_long;
typedef uint64_t xs_ulong;
typedef double xs_double;
typedef std::string xs_string;

#define DEFAULT_VALUE_XS_BOOL   false
#define DEFAULT_VALUE_XS_INT    INT_MIN
#define DEFAULT_VALUE_XS_UINT   0
#define DEFAULT_VALUE_XS_LONG   INT_MIN
#define DEFAULT_VALUE_XS_ULONG  0
#define DEFAULT_VALUE_XS_DOUBLE -1

/*
 * Helper macro for stringification of defines
 */
#undef STR
#define _STR(x) #x
#define STR(x) _STR(x)

template <int vmajor, int vminor, int vrelease>
struct version_t {
   std::string str() {
      std::stringstream ss;
      ss << vmajor << "." << vminor << "." << vrelease;
      return ss.str();
   }
};

/*
 * SimpleEnergyManagementProtocol definitions
 */

#define SEMP_BASE_URL_PATH_DEFAULT "/semp"
#define SEMP_BASE_URL_PORT_DEFAULT 80
#define SEMP_DOMAIN_NAME "schemas-simple-energy-management-protocol"
#define SEMP_DEVICE_TYPE "Gateway"
#define SEMP_DEVICE_TYPE_VER 1
#define SEMP_SERVICE_TYPE "SimpleEnergyManagementProtocol"
#define SEMP_SERVICE_TYPE_VER 1

#define SEMP_URN_DEVICE    SEMP_DOMAIN_NAME":device:"SEMP_DEVICE_TYPE":"STR(SEMP_DEVICE_TYPE_VER)
#define SEMP_URN_SERVICE   SEMP_DOMAIN_NAME":service:"SEMP_SERVICE_TYPE":"STR(SEMP_SERVICE_TYPE_VER)

#endif
