/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef ENERGYMANAGER_H_
#define ENERGYMANAGER_H_

#include <set>
#include "http/HTTPClient.h"
#include "ssdp/SSDPDiscovery.h"

/*! @class EnergyManager
 *
 * @brief This class represents an energy manager like the SMA Home Manager.
 */
class EnergyManager : public ISSDPDiscoveryHandler
{
public:
   /*!
    * @brief Constructor.
    */
   EnergyManager();

   /*!
    * @brief Destructor.
    */
   ~EnergyManager();

   /*!
    * @brief Callback handler called whenever the SSDP discovery module detects a new gateway.
    */
   virtual void updateSSDPDevice(SSDPDeviceState state, const SSDPDeviceInfo &info);

   /*!
    * @brief Sends an SEMP device request to the gateway.
    * @param url SEMP request URL (normally "<baseURL>/")
    * @param msg SEMP device message structure
    */
   bool sendDeviceRequest(const std::string &url, const SEMP::EM2Device &msg);

   /*!
    * @brief Sets the verbosity of console output.
    */
   void setVerbosity(int level);

   /*!
    * @brief Selects whether interactive demo mode (waits for key-presses) should be used or not.
    */
   void setInteractive(bool interactive);

   /*!
    * @brief Starts execution of the energy manager.
    */
   void start();

private:

   void waitForKeypress();

   /*!
    * @brief verbosity of console output.
    */
   int _verbosity;

   /*
    * if defined the demo waits for keypresses in each section.
    */
   bool _interactive;

   /*!
    * @brief SSDP discovery module used to find SimpleEnergyManagementProtocol gatways.
    */
   SSDPDiscovery _ssdpDiscovery;

   /*!
    * @brief HTTP client used to request information from the gateway.
    */
   HTTPClient _httpClient;

   /*!
    * @brief UPnP UUIDs of the gateways already found.
    */
   std::set<std::string> _knownGateways;
};

#endif
