#ifndef TIMEFRAME_H_
#define TIMEFRAME_H_

#include "../SEMPCommon.h"
#include "DeviceId.h"
#include "RelOrAbsTime.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

/*! \class Timeframe
 * Timeframe as part of a planning request, that allows specification of the energy needs of a device.
 */
class Timeframe : public SEMPObject
{
public:
   Timeframe();
private:
   /*!
    * Unique identification of the device.
    */
   DeviceId deviceId;

   /*!
    * Represents the earliest possible time the device can be switched on by the EM.
            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   RelOrAbsTime earliestStart;

   /*!
    * Represents the latest possible end time the requested minimum runtime (MinRunningTime) must be allocated to the device. This means at the given time the device operation must be finished. If a runtime was requested, the latest possible start of operation is LatestEnd-MinRunningTime.

            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   RelOrAbsTime latestEnd;

   /*!
    * Minimum running time within the timeframe in seconds.
            If MinRunningTime is 0, the operation of the device in this timeframe is optional.
            Defaults to 0 if MaxRunningTime is set.
    */
   xs_int minRunningTime;

   /*!
    * Maximum running time within the timeframe in seconds.
            If MinRunningTime equals MaxRunningTime, all of the given runtime is required. 
            If MinRunningTime is lower than MaxRunningTime, the amount of runtime given by MinRunningTime is required. The 
            runtime difference between MinRunningTime and MaxRunningTime is optional. That means that the EM will only assign the optional
            runtime to the device if certain conditions like ecological constraints and/or price of energy are met.
            Defaults to MinRunningTime if MinRunningTime is set.
    */
   xs_int maxRunningTime;


public:
   /*!
    * @brief Setter for DeviceId
    * Unique identification of the device.
    */
   void setDeviceId(DeviceId const &value_) {
      deviceId = value_;
      markAsSet("deviceId");
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   DeviceId& getDeviceId() {
      return deviceId;
   }

   /*!
    * @brief Getter for DeviceId
    * Unique identification of the device.
    */
   const DeviceId& getDeviceId() const {
      return deviceId;
   }

   /*!
    * @brief Checks if field DeviceId is set
    */
   bool isDeviceIdSet() const {
      return isSet("deviceId");
   }

   /*!
    * @brief Setter for RelOrAbsTime
    * Represents the earliest possible time the device can be switched on by the EM.
            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   void setEarliestStart(RelOrAbsTime const &value_) {
      earliestStart = value_;
      markAsSet("earliestStart");
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Represents the earliest possible time the device can be switched on by the EM.
            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   RelOrAbsTime& getEarliestStart() {
      return earliestStart;
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Represents the earliest possible time the device can be switched on by the EM.
            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   const RelOrAbsTime& getEarliestStart() const {
      return earliestStart;
   }

   /*!
    * @brief Checks if field RelOrAbsTime is set
    */
   bool isEarliestStartSet() const {
      return isSet("earliestStart");
   }

   /*!
    * @brief Setter for RelOrAbsTime
    * Represents the latest possible end time the requested minimum runtime (MinRunningTime) must be allocated to the device. This means at the given time the device operation must be finished. If a runtime was requested, the latest possible start of operation is LatestEnd-MinRunningTime.

            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   void setLatestEnd(RelOrAbsTime const &value_) {
      latestEnd = value_;
      markAsSet("latestEnd");
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Represents the latest possible end time the requested minimum runtime (MinRunningTime) must be allocated to the device. This means at the given time the device operation must be finished. If a runtime was requested, the latest possible start of operation is LatestEnd-MinRunningTime.

            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   RelOrAbsTime& getLatestEnd() {
      return latestEnd;
   }

   /*!
    * @brief Getter for RelOrAbsTime
    * Represents the latest possible end time the requested minimum runtime (MinRunningTime) must be allocated to the device. This means at the given time the device operation must be finished. If a runtime was requested, the latest possible start of operation is LatestEnd-MinRunningTime.

            The combination of EarliestStart and LatestEnd specifies the interval in which the requested runtime or energy has to be allocated by the EM.
    */
   const RelOrAbsTime& getLatestEnd() const {
      return latestEnd;
   }

   /*!
    * @brief Checks if field RelOrAbsTime is set
    */
   bool isLatestEndSet() const {
      return isSet("latestEnd");
   }

   /*!
    * @brief Setter for xs_int
    * Minimum running time within the timeframe in seconds.
            If MinRunningTime is 0, the operation of the device in this timeframe is optional.
            Defaults to 0 if MaxRunningTime is set.
    */
   void setMinRunningTime(xs_int value_) {
      minRunningTime = value_;
      markAsSet("minRunningTime");
   }

   /*!
    * @brief Getter for xs_int
    * Minimum running time within the timeframe in seconds.
            If MinRunningTime is 0, the operation of the device in this timeframe is optional.
            Defaults to 0 if MaxRunningTime is set.
    */
   xs_int getMinRunningTime() const {
      return minRunningTime;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMinRunningTimeSet() const {
      return isSet("minRunningTime");
   }

   /*!
    * @brief Setter for xs_int
    * Maximum running time within the timeframe in seconds.
            If MinRunningTime equals MaxRunningTime, all of the given runtime is required. 
            If MinRunningTime is lower than MaxRunningTime, the amount of runtime given by MinRunningTime is required. The 
            runtime difference between MinRunningTime and MaxRunningTime is optional. That means that the EM will only assign the optional
            runtime to the device if certain conditions like ecological constraints and/or price of energy are met.
            Defaults to MinRunningTime if MinRunningTime is set.
    */
   void setMaxRunningTime(xs_int value_) {
      maxRunningTime = value_;
      markAsSet("maxRunningTime");
   }

   /*!
    * @brief Getter for xs_int
    * Maximum running time within the timeframe in seconds.
            If MinRunningTime equals MaxRunningTime, all of the given runtime is required. 
            If MinRunningTime is lower than MaxRunningTime, the amount of runtime given by MinRunningTime is required. The 
            runtime difference between MinRunningTime and MaxRunningTime is optional. That means that the EM will only assign the optional
            runtime to the device if certain conditions like ecological constraints and/or price of energy are met.
            Defaults to MinRunningTime if MinRunningTime is set.
    */
   xs_int getMaxRunningTime() const {
      return maxRunningTime;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMaxRunningTimeSet() const {
      return isSet("maxRunningTime");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
