#include "PowerInfo.h"
#include "../SEMPCommon.h"
#include "RelOrAbsTime.h"

namespace SEMP
{

PowerInfo::PowerInfo() :
   averagePower(DEFAULT_VALUE_XS_INT),
   minPower(DEFAULT_VALUE_XS_INT),
   maxPower(DEFAULT_VALUE_XS_INT),
   averagingInterval(DEFAULT_VALUE_XS_INT)
{
}


void PowerInfo::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("averagePower")) {
         sstream << indentXML(level_) << "<AveragePower>";
         sstream << averagePower;
         sstream << "</AveragePower>\n";
   }
   if (isSet("minPower")) {
         sstream << indentXML(level_) << "<MinPower>";
         sstream << minPower;
         sstream << "</MinPower>\n";
   }
   if (isSet("maxPower")) {
         sstream << indentXML(level_) << "<MaxPower>";
         sstream << maxPower;
         sstream << "</MaxPower>\n";
   }
   if (isSet("timestamp")) {
         sstream << indentXML(level_) << "<Timestamp>";
         sstream << timestamp;
         sstream << "</Timestamp>\n";
   }
   if (isSet("averagingInterval")) {
         sstream << indentXML(level_) << "<AveragingInterval>";
         sstream << averagingInterval;
         sstream << "</AveragingInterval>\n";
   }
}

bool PowerInfo::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("averagePower")) { errElement_ = "averagePower"; return false; }
   if (!isSet("timestamp")) { errElement_ = "timestamp"; return false; }
   if (!isSet("averagingInterval")) { errElement_ = "averagingInterval"; return false; }
   return true;
}

}
