#ifndef POWERCONSUMPTION_H_
#define POWERCONSUMPTION_H_

#include "../SEMPCommon.h"
#include "PowerInfo.h"

namespace SEMP
{

/*! \class PowerConsumption
 * Information about the current power consumption of the device, or the power consumption of the device since the last communication.
 */
class PowerConsumption : public SEMPObject
{
public:
   PowerConsumption();
private:
   /*!
    * Information about a power consumption.
    */
   std::vector<PowerInfo> powerInfo; /* occurs: 1 .. 10 */


public:
   /*!
    * @brief Setter for PowerInfo
    * Information about a power consumption.
    */
   void addPowerInfo(PowerInfo const &value_) {
      powerInfo.push_back(value_);
      markAsSet("powerInfo");
   }

   const std::vector<PowerInfo>& getPowerInfoList() const {
      return powerInfo;
   }

   /*!
    * @brief Getter for PowerInfo
    * Information about a power consumption.
    */
   PowerInfo& getPowerInfo(size_t index) {
      return powerInfo[index];
   }

   /*!
    * @brief Getter for PowerInfo
    * Information about a power consumption.
    */
   const PowerInfo& getPowerInfo(size_t index) const {
      return powerInfo[index];
   }

   /*!
    * @brief Checks if field PowerInfo is set
    */
   bool isPowerInfoSet() const {
      return isSet("powerInfo");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
