#ifndef PLANNINGREQUEST_H_
#define PLANNINGREQUEST_H_

#include "../SEMPCommon.h"
#include "Timeframe.h"

namespace SEMP
{

/*! \class PlanningRequest
 * A PlanningRequest allows specification of the needs of the device with regard to energy and running time.
 */
class PlanningRequest : public SEMPObject
{
public:
   PlanningRequest();
private:
   /*!
    * Sequence of timeframes that constitute the planning request.
            Timeframes for one device must not overlap (in terms of earliestStart and latestEnd) as a device can only
            run once at a time.
            In case timeframes overlap the EM has to modify them (e.g. merge or strip) which might lead to unexpected
            behavior.
    */
   std::vector<Timeframe> timeframe; /* occurs: 1 .. unbounded */


public:
   /*!
    * @brief Setter for Timeframe
    * Sequence of timeframes that constitute the planning request.
            Timeframes for one device must not overlap (in terms of earliestStart and latestEnd) as a device can only
            run once at a time.
            In case timeframes overlap the EM has to modify them (e.g. merge or strip) which might lead to unexpected
            behavior.
    */
   void addTimeframe(Timeframe const &value_) {
      timeframe.push_back(value_);
      markAsSet("timeframe");
   }

   const std::vector<Timeframe>& getTimeframeList() const {
      return timeframe;
   }

   /*!
    * @brief Getter for Timeframe
    * Sequence of timeframes that constitute the planning request.
            Timeframes for one device must not overlap (in terms of earliestStart and latestEnd) as a device can only
            run once at a time.
            In case timeframes overlap the EM has to modify them (e.g. merge or strip) which might lead to unexpected
            behavior.
    */
   Timeframe& getTimeframe(size_t index) {
      return timeframe[index];
   }

   /*!
    * @brief Getter for Timeframe
    * Sequence of timeframes that constitute the planning request.
            Timeframes for one device must not overlap (in terms of earliestStart and latestEnd) as a device can only
            run once at a time.
            In case timeframes overlap the EM has to modify them (e.g. merge or strip) which might lead to unexpected
            behavior.
    */
   const Timeframe& getTimeframe(size_t index) const {
      return timeframe[index];
   }

   /*!
    * @brief Checks if field Timeframe is set
    */
   bool isTimeframeSet() const {
      return isSet("timeframe");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
