#include "PlanningRequest.h"
#include "../SEMPCommon.h"
#include "Timeframe.h"

namespace SEMP
{

PlanningRequest::PlanningRequest()
{
}


void PlanningRequest::serializeXML(std::stringstream &sstream, int level_) const
{
   {
      for (size_t i = 0; i < timeframe.size(); ++i) {
            sstream << indentXML(level_) << "<Timeframe>\n";
            timeframe[i].serializeXML(sstream, level_+1);
            sstream << indentXML(level_)<< "</Timeframe>\n";
      }
   }
}

bool PlanningRequest::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("timeframe")) { errElement_ = "timeframe"; return false; }
   for (size_t i = 0; i < timeframe.size(); ++i)
      if (!timeframe[i].validateXMLSchema(errElement_)) { errElement_ = "timeframe/" + errElement_; return false; }
   return true;
}

}
