#ifndef MESSAGELIST_H_
#define MESSAGELIST_H_

#include "../SEMPCommon.h"
#include "Message.h"

namespace SEMP
{

/*! \class MessageList
 * This type encapsulates a list of messages.
 */
class MessageList : public SEMPObject
{
public:
   MessageList();
private:
   /*!
    * This element encapsulates information about an error or event.
    */
   std::vector<Message> message; /* occurs: 1 .. unbounded */


public:
   /*!
    * @brief Setter for Message
    * This element encapsulates information about an error or event.
    */
   void addMessage(Message const &value_) {
      message.push_back(value_);
      markAsSet("message");
   }

   const std::vector<Message>& getMessageList() const {
      return message;
   }

   /*!
    * @brief Getter for Message
    * This element encapsulates information about an error or event.
    */
   Message& getMessage(size_t index) {
      return message[index];
   }

   /*!
    * @brief Getter for Message
    * This element encapsulates information about an error or event.
    */
   const Message& getMessage(size_t index) const {
      return message[index];
   }

   /*!
    * @brief Checks if field Message is set
    */
   bool isMessageSet() const {
      return isSet("message");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
