#ifndef MESSAGE_H_
#define MESSAGE_H_

#include "../SEMPCommon.h"
#include "MessageData.h"

namespace SEMP
{

/*! \class Message
 * This type encapsulates information about an error or event.
        It can also be used for data-tunnelling. In this case only the Type and Data elements might be set.
 */
class Message : public SEMPObject
{
public:
   Message();
   Message(const Message& rhs);
   Message& operator=(const Message& rhs);
private:
   /*!
    * The type of message used as a hint to interpret the message contents.
            See MessageTypeRefType for known values.
    */
   xs_string type;

   /*!
    * The severity of the message.
            See MessageLevelRefType for known values ("Info", "Warn", "Error").
    */
   xs_string level; /* occurs: 0 .. 1 */

   /*!
    * Additional data describing the error or event (e.g. for automatic evaluation).
            For "InvalidTimeframe" the element DeviceId will be set.
            For "DeviceControlIgnored" the element DeviceId will be set.
    */
   MessageData data; /* occurs: 0 .. 1 */

   /*!
    * Description of the error/event.
    */
   xs_string text; /* occurs: 0 .. 1 */


public:
   /*!
    * @brief Setter for xs_string
    * The type of message used as a hint to interpret the message contents.
            See MessageTypeRefType for known values.
    */
   void setType(xs_string const &value_) {
      type = value_;
      markAsSet("type");
   }

   /*!
    * @brief Getter for xs_string
    * The type of message used as a hint to interpret the message contents.
            See MessageTypeRefType for known values.
    */
   xs_string& getType() {
      return type;
   }

   /*!
    * @brief Getter for xs_string
    * The type of message used as a hint to interpret the message contents.
            See MessageTypeRefType for known values.
    */
   const xs_string& getType() const {
      return type;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isTypeSet() const {
      return isSet("type");
   }

   /*!
    * @brief Setter for xs_string
    * The severity of the message.
            See MessageLevelRefType for known values ("Info", "Warn", "Error").
    */
   void setLevel(xs_string const &value_) {
      level = value_;
      markAsSet("level");
   }

   /*!
    * @brief Getter for xs_string
    * The severity of the message.
            See MessageLevelRefType for known values ("Info", "Warn", "Error").
    */
   xs_string& getLevel() {
      return level;
   }

   /*!
    * @brief Getter for xs_string
    * The severity of the message.
            See MessageLevelRefType for known values ("Info", "Warn", "Error").
    */
   const xs_string& getLevel() const {
      return level;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isLevelSet() const {
      return isSet("level");
   }

   /*!
    * @brief Setter for MessageData
    * Additional data describing the error or event (e.g. for automatic evaluation).
            For "InvalidTimeframe" the element DeviceId will be set.
            For "DeviceControlIgnored" the element DeviceId will be set.
    */
   void setData(MessageData const &value_) {
      data = value_;
      data.setOnSetListener(this, "");
      markAsSet("data");
   }

   /*!
    * @brief Getter for MessageData
    * Additional data describing the error or event (e.g. for automatic evaluation).
            For "InvalidTimeframe" the element DeviceId will be set.
            For "DeviceControlIgnored" the element DeviceId will be set.
    */
   MessageData& getData() {
      return data;
   }

   /*!
    * @brief Getter for MessageData
    * Additional data describing the error or event (e.g. for automatic evaluation).
            For "InvalidTimeframe" the element DeviceId will be set.
            For "DeviceControlIgnored" the element DeviceId will be set.
    */
   const MessageData& getData() const {
      return data;
   }

   /*!
    * @brief Checks if field MessageData is set
    */
   bool isDataSet() const {
      return isSet("data");
   }

   /*!
    * @brief Setter for xs_string
    * Description of the error/event.
    */
   void setText(xs_string const &value_) {
      text = value_;
      markAsSet("text");
   }

   /*!
    * @brief Getter for xs_string
    * Description of the error/event.
    */
   xs_string& getText() {
      return text;
   }

   /*!
    * @brief Getter for xs_string
    * Description of the error/event.
    */
   const xs_string& getText() const {
      return text;
   }

   /*!
    * @brief Checks if field xs_string is set
    */
   bool isTextSet() const {
      return isSet("text");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
