#include "Message.h"
#include "../SEMPCommon.h"
#include "MessageData.h"

namespace SEMP
{

Message::Message()
{
   data.setOnSetListener(this, "data");
}


Message::Message(const Message& rhs) :
   SEMPObject(rhs),
   type(rhs.type),
   level(rhs.level),
   data(rhs.data),
   text(rhs.text)
{
   data.setOnSetListener(this, "data");
}

Message& Message::operator=(const Message& rhs)
{
   if(this != &rhs)
   {
      SEMPObject::operator=(rhs);
      type = rhs.type;
      level = rhs.level;
      data = rhs.data;
      data.setOnSetListener(this, "data");
      text = rhs.text;
   }
   return *this;
}

void Message::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("type")) {
         sstream << indentXML(level_) << "<Type>";
         sstream << escapeString(type);
         sstream << "</Type>\n";
   }
   if (isSet("level")) {
         sstream << indentXML(level_) << "<Level>";
         sstream << escapeString(level);
         sstream << "</Level>\n";
   }
   if (isSet("data")) {
         sstream << indentXML(level_) << "<Data>\n";
         data.serializeXML(sstream, level_+1);
         sstream << indentXML(level_)<< "</Data>\n";
   }
   if (isSet("text")) {
         sstream << indentXML(level_) << "<Text>";
         sstream << escapeString(text);
         sstream << "</Text>\n";
   }
}

bool Message::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("type")) { errElement_ = "type"; return false; }
   if (isSet("data") && !data.validateXMLSchema(errElement_)) { errElement_ = "data/" + errElement_; return false; }
   return true;
}

}
