#include "Identification.h"
#include "../SEMPCommon.h"
#include "DeviceId.h"

namespace SEMP
{

Identification::Identification()
{
}


void Identification::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("deviceId")) {
         sstream << indentXML(level_) << "<DeviceId>";
         sstream << deviceId;
         sstream << "</DeviceId>\n";
   }
   if (isSet("deviceName")) {
         sstream << indentXML(level_) << "<DeviceName>";
         sstream << escapeString(deviceName);
         sstream << "</DeviceName>\n";
   }
   if (isSet("deviceType")) {
         sstream << indentXML(level_) << "<DeviceType>";
         sstream << escapeString(deviceType);
         sstream << "</DeviceType>\n";
   }
   if (isSet("deviceSerial")) {
         sstream << indentXML(level_) << "<DeviceSerial>";
         sstream << escapeString(deviceSerial);
         sstream << "</DeviceSerial>\n";
   }
   if (isSet("deviceVendor")) {
         sstream << indentXML(level_) << "<DeviceVendor>";
         sstream << escapeString(deviceVendor);
         sstream << "</DeviceVendor>\n";
   }
   if (isSet("deviceURL")) {
         sstream << indentXML(level_) << "<DeviceURL>";
         sstream << escapeString(deviceURL);
         sstream << "</DeviceURL>\n";
   }
}

bool Identification::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("deviceId")) { errElement_ = "deviceId"; return false; }
   if (!isSet("deviceName")) { errElement_ = "deviceName"; return false; }
   if (!isSet("deviceType")) { errElement_ = "deviceType"; return false; }
   if (!isSet("deviceSerial")) { errElement_ = "deviceSerial"; return false; }
   if (!isSet("deviceVendor")) { errElement_ = "deviceVendor"; return false; }
   return true;
}

}
