#ifndef DEVICEINFO_H_
#define DEVICEINFO_H_

#include "../SEMPCommon.h"
#include "Identification.h"
#include "Characteristics.h"
#include "Capabilities.h"

namespace SEMP
{

/*! \class DeviceInfo
 * A DeviceInfo encapsulates all static information about a device such as identification, capabilities, restrictions, etc.
 */
class DeviceInfo : public SEMPObject
{
public:
   DeviceInfo();
   DeviceInfo(const DeviceInfo& rhs);
   DeviceInfo& operator=(const DeviceInfo& rhs);
private:
   /*!
    * General information for identifying the device.
    */
   Identification identification;

   /*!
    * Information on the characteristics of the device.
    */
   Characteristics characteristics;

   /*!
    * This element encapsulates information about the capabilities of the device
    */
   Capabilities capabilities;


public:
   /*!
    * @brief Setter for Identification
    * General information for identifying the device.
    */
   void setIdentification(Identification const &value_) {
      identification = value_;
      identification.setOnSetListener(this, "");
      markAsSet("identification");
   }

   /*!
    * @brief Getter for Identification
    * General information for identifying the device.
    */
   Identification& getIdentification() {
      return identification;
   }

   /*!
    * @brief Getter for Identification
    * General information for identifying the device.
    */
   const Identification& getIdentification() const {
      return identification;
   }

   /*!
    * @brief Checks if field Identification is set
    */
   bool isIdentificationSet() const {
      return isSet("identification");
   }

   /*!
    * @brief Setter for Characteristics
    * Information on the characteristics of the device.
    */
   void setCharacteristics(Characteristics const &value_) {
      characteristics = value_;
      characteristics.setOnSetListener(this, "");
      markAsSet("characteristics");
   }

   /*!
    * @brief Getter for Characteristics
    * Information on the characteristics of the device.
    */
   Characteristics& getCharacteristics() {
      return characteristics;
   }

   /*!
    * @brief Getter for Characteristics
    * Information on the characteristics of the device.
    */
   const Characteristics& getCharacteristics() const {
      return characteristics;
   }

   /*!
    * @brief Checks if field Characteristics is set
    */
   bool isCharacteristicsSet() const {
      return isSet("characteristics");
   }

   /*!
    * @brief Setter for Capabilities
    * This element encapsulates information about the capabilities of the device
    */
   void setCapabilities(Capabilities const &value_) {
      capabilities = value_;
      capabilities.setOnSetListener(this, "");
      markAsSet("capabilities");
   }

   /*!
    * @brief Getter for Capabilities
    * This element encapsulates information about the capabilities of the device
    */
   Capabilities& getCapabilities() {
      return capabilities;
   }

   /*!
    * @brief Getter for Capabilities
    * This element encapsulates information about the capabilities of the device
    */
   const Capabilities& getCapabilities() const {
      return capabilities;
   }

   /*!
    * @brief Checks if field Capabilities is set
    */
   bool isCapabilitiesSet() const {
      return isSet("capabilities");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
