#ifndef CHARACTERISTICS_H_
#define CHARACTERISTICS_H_

#include "../SEMPCommon.h"

namespace SEMP
{

/*! \class Characteristics
 * Information on the characteristics of the device.
 */
class Characteristics : public SEMPObject
{
public:
   Characteristics();
private:
   /*!
    * Nominal maximum power consumption of the device in Watts. If the device is controllable with regard to power consumption, the recommendation
            of the energy management system will never exceed this value.
    */
   xs_int maxPowerConsumption;

   /*!
    * If the device is switched on, it has to remain in this status for at least MinOnTime seconds.
    */
   xs_int minOnTime; /* occurs: 0 .. 1 */

   /*!
    * If the device is switched off, it has to remain in this status for at least MinOffTime seconds.
    */
   xs_int minOffTime; /* occurs: 0 .. 1 */


public:
   /*!
    * @brief Setter for xs_int
    * Nominal maximum power consumption of the device in Watts. If the device is controllable with regard to power consumption, the recommendation
            of the energy management system will never exceed this value.
    */
   void setMaxPowerConsumption(xs_int value_) {
      maxPowerConsumption = value_;
      markAsSet("maxPowerConsumption");
   }

   /*!
    * @brief Getter for xs_int
    * Nominal maximum power consumption of the device in Watts. If the device is controllable with regard to power consumption, the recommendation
            of the energy management system will never exceed this value.
    */
   xs_int getMaxPowerConsumption() const {
      return maxPowerConsumption;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMaxPowerConsumptionSet() const {
      return isSet("maxPowerConsumption");
   }

   /*!
    * @brief Setter for xs_int
    * If the device is switched on, it has to remain in this status for at least MinOnTime seconds.
    */
   void setMinOnTime(xs_int value_) {
      minOnTime = value_;
      markAsSet("minOnTime");
   }

   /*!
    * @brief Getter for xs_int
    * If the device is switched on, it has to remain in this status for at least MinOnTime seconds.
    */
   xs_int getMinOnTime() const {
      return minOnTime;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMinOnTimeSet() const {
      return isSet("minOnTime");
   }

   /*!
    * @brief Setter for xs_int
    * If the device is switched off, it has to remain in this status for at least MinOffTime seconds.
    */
   void setMinOffTime(xs_int value_) {
      minOffTime = value_;
      markAsSet("minOffTime");
   }

   /*!
    * @brief Getter for xs_int
    * If the device is switched off, it has to remain in this status for at least MinOffTime seconds.
    */
   xs_int getMinOffTime() const {
      return minOffTime;
   }

   /*!
    * @brief Checks if field xs_int is set
    */
   bool isMinOffTimeSet() const {
      return isSet("minOffTime");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
