#include "Characteristics.h"
#include "../SEMPCommon.h"

namespace SEMP
{

Characteristics::Characteristics() :
   maxPowerConsumption(DEFAULT_VALUE_XS_INT),
   minOnTime(DEFAULT_VALUE_XS_INT),
   minOffTime(DEFAULT_VALUE_XS_INT)
{
}


void Characteristics::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("maxPowerConsumption")) {
         sstream << indentXML(level_) << "<MaxPowerConsumption>";
         sstream << maxPowerConsumption;
         sstream << "</MaxPowerConsumption>\n";
   }
   if (isSet("minOnTime")) {
         sstream << indentXML(level_) << "<MinOnTime>";
         sstream << minOnTime;
         sstream << "</MinOnTime>\n";
   }
   if (isSet("minOffTime")) {
         sstream << indentXML(level_) << "<MinOffTime>";
         sstream << minOffTime;
         sstream << "</MinOffTime>\n";
   }
}

bool Characteristics::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("maxPowerConsumption")) { errElement_ = "maxPowerConsumption"; return false; }
   return true;
}

}
