#include "CapTimestamp.h"
#include "../SEMPCommon.h"

namespace SEMP
{

CapTimestamp::CapTimestamp() :
   absoluteTimestamps(false)
{
}


void CapTimestamp::serializeXML(std::stringstream &sstream, int level_) const
{
   if (isSet("absoluteTimestamps")) {
         sstream << indentXML(level_) << "<AbsoluteTimestamps>";
         sstream << std::boolalpha << absoluteTimestamps << std::noboolalpha;
         sstream << "</AbsoluteTimestamps>\n";
   }
}

bool CapTimestamp::validateXMLSchema(std::string &errElement_) const
{
   if (!isSet("absoluteTimestamps")) { errElement_ = "absoluteTimestamps"; return false; }
   return true;
}

}
