#ifndef CAPREQUESTS_H_
#define CAPREQUESTS_H_

#include "../SEMPCommon.h"

namespace SEMP
{

/*! \class CapRequests
 * Specifies options related to planning requests.
 */
class CapRequests : public SEMPObject
{
public:
   CapRequests();
private:
   /*!
    * 
    */
   xs_bool optionalEnergy;


public:
   /*!
    * @brief Setter for xs_bool
    * 
    */
   void setOptionalEnergy(xs_bool value_) {
      optionalEnergy = value_;
      markAsSet("optionalEnergy");
   }

   /*!
    * @brief Getter for xs_bool
    * 
    */
   xs_bool getOptionalEnergy() const {
      return optionalEnergy;
   }

   /*!
    * @brief Checks if field xs_bool is set
    */
   bool isOptionalEnergySet() const {
      return isSet("optionalEnergy");
   }

   virtual void serializeXML(std::stringstream &sstream, int level_ = 0) const;
   virtual bool validateXMLSchema(std::string &errElement_) const;
};

}

#endif
