/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef HTTPCOMMON_H_
#define HTTPCOMMON_H_

#include <string>

enum HTTPMethod
{
   HTTP_METHOD_GET,
   HTTP_METHOD_POST,
   HTTP_METHOD_UNKNOWN
};

enum HTTPStatus
{
   HTTP_STATUS_OK           = 200,
   HTTP_STATUS_CREATED      = 201,
   HTTP_STATUS_ACCEPTED     = 202,
   HTTP_STATUS_BAD_REQUEST  = 400,
   HTTP_STATUS_NOT_FOUND    = 404
};

namespace HTTPResponseField {
   extern const char* CONTENT_TYPE;
}

/*! @class HTTPMessageHeaderBuffer
 * @brief Base class for HTTP request and response.
 * For HTTP 1.1 this is defined in RFC 2616.
 */
class HTTPMessageHeaderBuffer
{
public:
   bool getField(const std::string &name, std::string &value) const;

public:
   std::string buffer;
};


static inline const char* HttpStatusMsg(HTTPStatus status) {
   switch (status)
   {
   case HTTP_STATUS_OK: return "OK";
   case HTTP_STATUS_NOT_FOUND: return "Not Found";
   default: return "";
   }
};

/*! @class HTTPCommon
 *
 * @brief HTTPCommon contains methods common for HTTP server and client.
 */
class HTTPCommon
{
public:
   /*!
    * @brief Receives an HTTP message on socket @p sock and splits it into header and body.
    *
    * @param sock the socket to listen on
    * @param client set to true if the method is called by a HTTP client, set to false for a HTTP server
    * @param header the received header
    * @param body the received body
    * @param timeout the timeout in seconds after which the read operation should be aborted
    *
    * @return true if a valid HTTP message was received, false otherwise
    */
   static bool recvMessage(int sock, bool client, std::string &header, std::string &body, time_t timeout);
};

#endif
