/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2011
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************
 *
 *  $State$
 *
 *  $Revision$
 *
 *  $Log$
 *
 ***************************************************************************/

#ifndef UNCOPYABLE_H_
#define UNCOPYABLE_H_

/*! @class Uncopyable
 *
 * @brief This class prevents objects from classes derived from it to be copied.
 *
 * Normally for each class a default copy-constructors and assignment-operator (operator=)
 * are generated if none is specified, so a class is copyable by default.
 *
 * To make a class uncopyable derive from this class as follows:
 * "class MyClass : private Uncopyable { ..."
 */
class Uncopyable {
protected:
   Uncopyable() {}
   ~Uncopyable() {}

private:
   Uncopyable(const Uncopyable&);
   Uncopyable& operator=(const Uncopyable&);
};


#endif
