/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <cassert>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <iostream>
#include "UDPSocket.h"
#include "Logger.h"

UDPSocket::UDPSocket() :
      _socket(-1)
{
   _socket = socket(AF_INET, SOCK_DGRAM, 0);
   if (_socket == -1) {
      Logger::log() << "UDP socket creation failed" << std::endl;
   }

   memset(&_dstAddr, 0, sizeof(_dstAddr));
   _dstAddr.sin_family = AF_INET;
}


UDPSocket::~UDPSocket()
{
   if (_socket >= 0)
      close(_socket);
}

void UDPSocket::setDestination(const char *dstAddr, int port)
{
   inet_aton(dstAddr, &(_dstAddr.sin_addr));
   _dstAddr.sin_port = htons(port);
}

void UDPSocket::setDestination(const sockaddr_in &dstAddr)
{
   _dstAddr = dstAddr;
}

ssize_t UDPSocket::send(const char* buffer, size_t length)
{
   ssize_t ret = sendto(_socket, buffer, length, 0, (sockaddr *)&_dstAddr, sizeof(_dstAddr));
   if (ret == -1) {
      perror("sendto");
   }
   return ret;
}

ssize_t UDPSocket::receive(char* buffer, size_t length)
{
   fd_set fdset;
   FD_ZERO(&fdset);
   FD_SET(_socket, &fdset);

   struct timeval tv;
   tv.tv_sec = 0;
   tv.tv_usec = 200000;

   int retval = select(_socket+1, &fdset, NULL, NULL, &tv);
   if (retval != -1 && FD_ISSET(_socket, &fdset))
   {
      // receive number of sent bytes
      return recvfrom(_socket, buffer, length, 0, 0, 0);
   }
   else
   {
      Logger::log() << "Timeout Received" << std::endl;
      return 0;
   }
}
