/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef PROPERTYMAP_H_
#define PROPERTYMAP_H_

#include <string>
#include <map>
#include <string.h>

/*!
 * @brief Case-insensitive string comparison function.
 */
struct ciLess : public std::binary_function<std::string, std::string, bool> {
    bool operator()(const std::string &lhs, const std::string &rhs) const {
        return strcasecmp(lhs.c_str(), rhs.c_str()) < 0 ? 1 : 0;
    }
};

/*!
 * @brief A map storing key-value pairs with case-insensitive keys.
 */
typedef std::map<std::string, std::string, ciLess> propertyMap_t;

#endif
