/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef LOGGER_H_
#define LOGGER_H_

#include <iostream>

/*! @class Logger
 *
 * @brief Logs messages to console output.
 */
class Logger
{
public:
   enum LogLevel {
      Info,
      Warn,
      Error
   };

   static void setOStream(std::ostream &stream);

   /*!
    * @brief Logs message @str to console output.
    */
   static std::ostream& log(bool header = true, LogLevel level = Info);

   static std::ostream& info(bool header = true) {
      return log(header, Info);
   }

   static std::ostream& warn(bool header = true) {
      return log(header, Warn);
   }

   static std::ostream& error(bool header = true) {
      return log(header, Error);
   }

private:
   static std::ostream *_stream;
};


#endif
